; ------------------- boot.asm ------------------------------------------
;
; Floppy boot segment   changed to assemble under nasm
; (note; no room left on the boot sector, none! <g>)

[ORG 0]				 		; actually 7c00
[BITS 16]
start: 	jmp  short start0
    	nop

    	db 'cmcf 1.0'
    	dw 512     				; bytes/sector
    	db 1       				; sector/cluster
    	dw 1       				; sector reserved
    	db 2       				; FATs
    	dw 16*14   				; root directory entries
    	dw 80*2*18 				; sectors
    	db 0x0F0    				; media
    	dw 9       				; sectors/FAT
    	dw 18      				; sectors/track
    	dw 2       				; heads
    	dd 0       				; hidden sectors
    	dd 80*2*18 				; sectors again
    	db 0       				; drive

gdt:
	dw 0x17
    	dd gdt0
	
	align 8
gdt0:
	dw 0, 0, 0, 0
    	dw 0x0FFFF, 0, 0x9A00, 0x0CF 		; code
    	dw 0x0FFFF, 0, 0x9200, 0x0CF 		; data

;;; 
;;; message: write the string pointed to by %si
;;; 
;;;   WARNING: trashes %si, %ax, and %bx
;;;
;;; Use BIOS "int 10H Function 0Eh" to write character in teletype mode
;;;	ah = 0xe	al = character
;;;	bh = page	bl = foreground color (graphics modes)
;;;
;;;
;;; Taken from the GRUB boot code, slightly simplified:	
;;; this version assumes a non-empty string.

message:
	lodsb
.lp:	
	mov bx,0x0001
	mov ah,	0xe
	int 0x10				; display a byte
	lodsb
	cmp al,0				; loop if not end of string
	jne .lp
	ret


boot_error:
	mov si, msg.error+0x7c00
	call message
	jmp $-$$				; endless loop

start0:

;;; Give a sign
	mov si, msg.hello+0x7c00
	call message

;;; Load first track to 0x1000:0x0000, i.e. 64K
	mov dx, 0x1000
	mov es, dx
	xor dx, dx				; drive 0, head 0
	xor bx, bx				; offset 0
	mov cx, 0x0001				; track 0, sector 1
	mov ax, 0x0224				; function read, entire track

	push ax					; dummy read to spin up drive
	int 0x13
	pop ax

	add bx, 0x12*0x400			; offset 18K
	mov cx, 0x0101				; track 1, sector 1
	int 0x13				; actual read
	jc boot_error
	mov ax, 0x0224				; function read, entire track
	int 0x13
	jc boot_error

	push es					; save buffer segment
	mov si, msg.done+0x7c00
	call message

;;; Set video mode
	mov ax, 0x7c20				; executed from 7c00
	mov es, ax
	xor di, di				; at the end of sector
	mov ax, 0x4f01
	mov cx, vesa+0x4000			; ask for linear buffer
	int 0x10
	mov ax, 0x4F02 				; Video mode
    	mov bx, vesa+0x4000			; hp*vp rgb: 565
    	int 0x10
	mov ebp, [es:di+40]

    	cli

;;; Copy the first 30 blocks to address 0
	pop ds					; restore buffer segment
	xor ax,ax				; destination: segment 0x00
	mov es,ax
	xor si,si				; offset is zero
	xor di,di
	mov cx,0x400*30/4			; 30 blocks
	rep movsd

	jmp 0x0:relocate			; jump to segment 0x00

relocate:			; from here on we are relative to address 0
	mov ds,ax
	lgdt [gdt]
	mov al,0x1
	mov cr0,eax
	jmp 0x8:protected

[BITS 32]
protected:
	mov al, 0x10
	mov ds, eax
	mov es, eax
	mov ss, eax
	mov esp, Gods				; return stack
	mov esi, Godd				; data stack
	xor ecx, ecx

A20:
	mov al, 0xd1
	out 0x64, al
.a20:	in al, 0x64
	and al, 2
	jnz .a20
	mov al, 0x4b
	out 0x60, al

;;; FIXME: warm start not yet implemented
	jmp start1

msg.hello:	db "Booting colorForth... ",0
msg.error:	db "failed :(",0
msg.done:	db "done.",0

	times 512-2-($-$$) db 0
	dw 0xaa55
	dd 0x44444444

; ------------ end boot.asm -------------------------------------------

