/*
 * Proll takes this from Sparclinux kernel, ruthlessly truncated
 * because we have no user windows.
 *
 * Copyright (C) 1995 David S. Miller (davem@caip.rutgers.edu)
 */

#include <asm/cprefix.h>
#include <asm/contregs.h>
#include <asm/page.h>
/* #include <asm/ptrace.h> */
#include <asm/psr.h>
/* #include <asm/smp.h> */
#include <asm/asi.h>
#include <asm/winmacro.h>
#include <asm/asmmacro.h>

/* We define macro's for registers which have a fixed
 * meaning throughout this entire routine.  The 'T' in
 * the comments mean that the register can only be
 * accessed when in the 'trap' window, 'G' means
 * accessible in any window.  Do not change these registers
 * after they have been set, until you are ready to return
 * from the trap.
 */
#define t_psr       l0 /* %psr at trap time                     T */
#define t_pc        l1 /* PC for trap return                    T */
#define t_npc       l2 /* NPC for trap return                   T */
#define t_wim       l3 /* %wim at trap time                     T */
#define saved_g5    l5 /* Global save register                  T */
#define saved_g6    l6 /* Global save register                  T */

/* Now registers whose values can change within the handler.      */
#define twin_tmp    l4 /* Temp reg, only usable in trap window  T */
#define glob_tmp    g5 /* Global temporary reg, usable anywhere G */

	.text
	.align	4
	/* BEGINNING OF PATCH INSTRUCTIONS */
	/* On a 7-window Sparc the boot code patches spnwin_*
	 * instructions with the following ones.
	 */
	.globl	spnwin_patch1_7win, spnwin_patch2_7win, spnwin_patch3_7win
spnwin_patch1_7win:	sll	%t_wim, 6, %glob_tmp
spnwin_patch2_7win:	and	%glob_tmp, 0x7f, %glob_tmp
spnwin_patch3_7win:	and	%twin_tmp, 0x7f, %twin_tmp
	/* END OF PATCH INSTRUCTIONS */

	/* The trap entry point has done the following:
	 *
	 * rd    %psr, %l0
	 * rd    %wim, %l3
	 * b     spill_window_entry
	 * nop
	 */

	.globl	spill_window_entry 
	.globl	spnwin_patch1, spnwin_patch2, spnwin_patch3
spill_window_entry:
	/* LOCATION: Trap Window */

	mov	%g5, %saved_g5		! save away global temp register
	mov	%g6, %saved_g6		! save away 'current' ptr register

	/* Compute what the new %wim will be if we save the
	 * window properly in this trap handler.
	 *
	 * newwim = ((%wim>>1) | (%wim<<(nwindows - 1)));
	 */
		srl	%t_wim, 0x1, %twin_tmp
spnwin_patch1:	sll	%t_wim, 7, %glob_tmp
		or	%glob_tmp, %twin_tmp, %glob_tmp
spnwin_patch2:	and	%glob_tmp, 0xff, %glob_tmp

	/* Save into the window which must be saved and do it.
	 */
	save	%g0, %g0, %g0		! save into the window to stash away
	wr	%glob_tmp, 0x0, %wim	! set new %wim, this is safe now

	/* LOCATION: Window to be saved */

	STORE_WINDOW(sp)		! stash the window
	restore	%g0, %g0, %g0		! go back into trap window

	/* LOCATION: Trap window */
	mov	%saved_g5, %g5		! restore %glob_tmp
	mov	%saved_g6, %g6		! restore %curptr
	wr	%t_psr, 0x0, %psr	! restore condition codes in %psr
	nop; nop; nop			! waste some time
	jmp	%t_pc			! Return from trap
	rett	%t_npc			! we are done
