/*
 * system.h - replaces <linux/system.h> and other headers,
 * also contains common definitions, exported by incarnations of main.c.
 * See COPYING for details.
 */

/*
 * True miscellanea from main.c.
 */

#define AOUT_MAGIC  0x01030107

#define LOADBASE 0x4000         /* VA == PA */
#define PROLSIZE (240*1024)	/* This size covers runtime dynamic memory */
#define LOWMEMSZ (8*1024*1024)  /* We promise 8MB of low mappings to kernel */
#define IOMAPSIZE (1*1024*1024) /* 1 Meg maximum: we do not map framebuffer. */
#define NCTX_SWIFT  0x100

#define MAX_BANKS      3		/* Allocation for all machines */

#ifndef __ASSEMBLY__
struct bank {
	unsigned int start;		/* 32 bits of physical address */
	unsigned int length;
};
#endif

#ifndef __ASSEMBLY__

/*
 * head.S
 */
/* extern int _start; */        /* in head.S.. we use PROLBASE. */
extern int _end;                /* ld made it for us */

extern void st_bypass(unsigned int ptr, unsigned int data);
extern unsigned int ld_bypass(unsigned int ptr);
extern void sth_bypass(unsigned int ptr, unsigned int data);
extern unsigned int ldh_bypass(unsigned int ptr);
extern void stb_bypass(unsigned int ptr, unsigned int data);
extern unsigned int ldb_bypass(unsigned int ptr);
extern void move_phys_high(unsigned int newphys, int);

/*
 * sched.c
 * Plus emulator of <linux/sched.h>
 */
extern int sched_init(void);

extern int request_irq(unsigned int irq, void (*handler)(void *), void *dev_id);
extern void free_irq(unsigned int irq, void *dev_id);

/*
 * openprom.c
 */
extern void *init_openprom(int bankc, struct bank *bankv, unsigned hibas);

/*
 * drivers
 */
extern void le_probe(void);
extern void hme_probe(void);
extern void cse_probe(void);

/*
 * main.c
 */
/*
 */
struct banks {
        int nbanks;
        struct bank bankv[MAX_BANKS];
};

/*
 * system.c { iommu.c , pcic.c }
 */
/*
 * Allocatable memory chunk.
 */
struct mem {
        char *start, *uplim;
        char *curp;
};

/*
 * Physical memory parameters
 */
struct phym {
        unsigned *pctp;         /* Virtual address of context table */
        unsigned *pl1;          /* Virtual address of root table */
        unsigned pbas;          /* Offset of ourselves in physical memory */
};

/*
 * IOMMU parameters
 */
struct iommu {
        struct iommu_regs *regs;
        unsigned int *page_table;
        unsigned long plow;     /* Base bus address */
        unsigned long vasize;   /* Size of VA region that we manage */
        struct mem bmap;
};

struct pcic {
	unsigned regs;		/* == PHYS_JK_PCIC */
	/* undigned hibas; */	/* Phys base for V2P translations */
};

void get_banks_layout(struct banks *, unsigned int);
unsigned int proc_tablewalk(int ctx, unsigned int va);
unsigned int mem_tablewalk(unsigned int pa, unsigned int va);
void makepages(struct phym *this, unsigned int highbase);
int map_page(unsigned int *pgd, unsigned int va, unsigned int epa, int type,
    unsigned int highbase);
void init_mmu_swift(unsigned int ctxtab_pa);
void run_timers(void);

void iommu_init(struct iommu *t, unsigned int highbase);
void *iommu_alloc(struct iommu *t, int size, unsigned int *pphys);
void pcic_init(struct pcic *t, unsigned int highbase);
void *pcic_alloc(struct pcic *t, int size, unsigned int *pphys);
unsigned long pcic_virt_to_bus(volatile void *);
void pcic_map_irq(struct pcic *t, unsigned int pin, unsigned int irq);

void mem_init(struct mem *t, char *begin, char *limit);
void mem_fini(struct mem *t);
void *mem_alloc(struct mem *t, int size, int align);
void *mem_zalloc(struct mem *t, int size, int align);
int load(unsigned int ipaddr, char *name);

extern struct vconterm dp0;
extern struct mem cmem;                /* Current memory, virtual */
extern struct mem cio;                 /* Current I/O space */
extern struct phym pmem;               /* Current phys. mem. */

extern void *map_io(unsigned pa, int size);
void *dvma_alloc(int size, unsigned int *pphys);
unsigned long virt_to_bus(volatile void *addr);
unsigned long sbus_dvma_addr(void *);
void udelay(unsigned long usecs);
extern void st_bp_swap(unsigned int ptr, unsigned int data);
extern unsigned int ld_bp_swap(unsigned int ptr);

#define IDPROM_SIZE	16
extern char idprom[IDPROM_SIZE];

/*
 */
extern void init_eeprom(void);		/* Only on Krups and Espresso */

/*
 * Currently we work w/o interrupts until SAVE_ALL/RESTORE_ALL are done
 */
/* Changing the IRQ level on the Sparc.   We now avoid writing the psr
 * whenever possible.
 */
#ifndef PSR_PIL
#define PSR_PIL	0x00000f00
#endif

extern __inline__ void setipl(unsigned long __orig_psr)
{
	__asm__ __volatile__("
		wr	%0, 0x0, %%psr
		nop; nop; nop
"		: /* no outputs */
		: "r" (__orig_psr)
		: "memory", "cc");
}

extern __inline__ void __cli(void)
{
	unsigned long tmp;

	__asm__ __volatile__("
		rd	%%psr, %0
		nop; nop; nop;		/* Sun4m + Cypress + SMP bug */
		or	%0, %1, %0
		wr	%0, 0x0, %%psr
		nop; nop; nop
"		: "=r" (tmp)
		: "i" (PSR_PIL)
		: "memory");
}

extern __inline__ void __sti(void)
{
	unsigned long tmp;

	__asm__ __volatile__("
		rd	%%psr, %0	
		nop; nop; nop;		/* Sun4m + Cypress + SMP bug */
		andn	%0, %1, %0
		wr	%0, 0x0, %%psr
		nop; nop; nop
"		: "=r" (tmp)
		: "i" (PSR_PIL)
		: "memory");
}

extern __inline__ unsigned long getipl(void)
{
	unsigned long retval;

	__asm__ __volatile__("rd	%%psr, %0" : "=r" (retval));
	return retval;
}

extern __inline__ unsigned long swap_pil(unsigned long __new_psr)
{
	unsigned long retval;

	__asm__ __volatile__("
		rd	%%psr, %0
		nop; nop; nop;		/* Sun4m + Cypress + SMP bug */
		and	%0, %2, %%g1
		and	%1, %2, %%g2
		xorcc	%%g1, %%g2, %%g0
		be	1f
		 nop
		wr	%0, %2, %%psr
		nop; nop; nop;
1:
"		: "=r" (retval)
		: "r" (__new_psr), "i" (PSR_PIL)
		: "g1", "g2", "memory", "cc");

	return retval;
}

extern __inline__ unsigned long read_psr_and_cli(void)
{
	unsigned long retval;

	__asm__ __volatile__("
		rd	%%psr, %0
		nop; nop; nop;		/* Sun4m + Cypress + SMP bug */
		or	%0, %1, %%g1
		wr	%%g1, 0x0, %%psr
		nop; nop; nop
"		: "=r" (retval)
		: "i" (PSR_PIL)
		: "g1", "memory");

	return retval;
}

#define __save_flags(flags)	((flags) = getipl())
#define __save_and_cli(flags)	((flags) = read_psr_and_cli())
#define __restore_flags(flags)	setipl((flags))

#define cli() __cli()
/* #define sti() __sti() */	/* Keep sti() covered until we get interrupts */
#define save_flags(x) __save_flags(x)
#define restore_flags(x) __restore_flags(x)
#define save_and_cli(x) __save_and_cli(x)

/* XXX Change this if we ever use a PSO mode kernel. */
#define mb()		__asm__ __volatile__ ("" : : : "memory")
/* Optimization barrier */
/* The "volatile" is due to gcc bugs */
#define barrier()	__asm__ __volatile__ ("" : : : "memory")

#define nop() __asm__ __volatile__ ("nop")

extern unsigned long volatile jiffies;
#define HZ  10

#define mark_bh(level)	/* */

#endif /* __ASSEMBLY__ */
