/*
 * hconsole.c
 *
 * The hconsole class presents a raster of characters.
 * This implementation of hconsole works with a Sun style bitmap.
 * Other implementation could work with a text mode hardware, such as VGA.
 *
 * Copyright 1995, 1999 Pete Zaitcev
 */

#include <linux/types.h>
#include <asm/types.h>

#include "hconsole.h"

#include "rconsole.h"
#include "phys_jj.h"

#if 0
/*
 * Basicaly I want to cover all PROM output and to scroll it up.
 * The simplest way is to use all screen real estate. But I personaly
 * prefer a smaller console. Someone to elaborate this later... --P3
 */
#define RCON_NICEMARGIN   50
#endif

static struct rfont f_master;	/* Master font for resets */
       struct raster r_master;	/* For a case of resize, whole fb */
       struct raster r_0;	/* malloc() erzatz */

int hcon_init(struct hconsole *t, unsigned int a0)
{
	struct raster *q, *r;

	r = &r_0;		/* malloc() */
	q = &r_master;		/* malloc() */

	font_cons_7(&f_master);	/* per-instance init of a constant. */

	/*
 	 * No probing sequence or argument passing, hardcode everything. XXX
	 */
	raster8_cons_a(q, 768, 1024, (char *)a0);
	raster_cons_2(r, q, 768-(24*11)-1, 1024-(8*80)-1, (24*11), (8*80));
	t->r_ = r;
	t->r0_ = q;
	t->f_ = &f_master;
	t->color_ = 1;
	t->name_[0] = '@';
	t->name_[1] = 0;

	/* P3: Palette is twisted in a strange way in my SS2/cg6.  */
	/* By default 255 maps to black, 0 maps to white.          */
	/* (*r_console.clear_)(&r_console, 0, 0, h1, w1, 255); */

	t->ydim_ = raster_qheight(t->r_)/t->f_->height_;
	t->xdim_ = raster_qwidth(t->r_)/t->f_->width_;

	t->bg_ = 255;
	t->fg_ =   0;

	t->ypos_ = 0;
	t->xpos_ = 0;
	t->curson_ = 0;	/* XXX Stay off until we get cell buffer. */

	return 0;
}

void hcon_fini (struct hconsole *t)
{
	return;
}

int hcon_clear (struct hconsole *t,
                         int sy, int sx, int height, int width)
{
	struct rfont *f = t->f_;

	if (sy < 0 || sy >= t->ydim_) return -1;
	if (sx < 0 || sx >= t->xdim_) return -1;
	if (height < 0) return -1;
	if (sy + height > t->ydim_) height = t->ydim_ - sy;
	if (width < 0) return -1;
	if (sx + width > t->xdim_) width = t->xdim_ - sx;

	/* XXX Clear with correct background color */
	(*t->r_->clear_)(t->r_,
			   sy*f->height_, sx*f->width_,
			   height*f->height_, width*f->width_,
			   t->bg_);

	if (t->curson_) {
		char c0 = 0;      /* c0 = *conp->vc_pos & 0xFF; */

		(*t->r_->render_)(t->r_,
				    t->ypos_*f->height_, t->xpos_*f->width_,
				    &c0, 1, t->fg_, t->bg_, f);
	}

	return 0;
}

int hcon_putc (struct hconsole *t, int c, int y, int x)
{
	struct rfont *f = t->f_;
	char c0 = c;
	RC_color rfg, rbg;

	if (y < 0 || y >= t->ydim_) return -1;
	if (x < 0 || x >= t->xdim_) return -1;

	if (t->curson_ && t->ypos_ == y && t->xpos_ == x) {
		rfg = t->bg_;    rbg = t->fg_;
	} else {
		rfg = t->fg_;    rbg = t->bg_;
	}
	(*t->r_->render_)(t->r_, y*f->height_, x*f->width_,
				 &c0, 1, rbg, rfg, f);

	return 0;
}

int hcon_putcs (struct hconsole *t, const char *s,
                         int count, int y, int x)
{	
	struct rfont *f = t->f_;

	if (y < 0 || y >= t->ydim_) return -1;
	if (x < 0 || x >= t->xdim_) return -1;
	if (x + count >= t->xdim_) count = t->xdim_ - x;

	(*t->r_->render_)(t->r_, y*f->height_, x*f->width_,
			    s, count, t->bg_, t->fg_, f);

	if (t->curson_) {
		char c0 = 0;    /* c0 = *conp->vc_pos & 0xFF; */

		(*t->r_->render_)(t->r_,
				    t->ypos_*f->height_,
				    t->xpos_*f->width_,
				    &c0, 1, t->fg_, t->bg_, f);
	}

	return 0;
}

#if 0
int hcon_cursor(struct hconsole *t, int mode)
{
	struct rfont *f = t->f_;
	char c0 = 0;   /* c0 = *conp->vc_pos & 0xFF; */

	switch (mode) {
	case CM_MOVE:		/* Not used in present, equivalent to DRAW */
	case CM_DRAW:
		t->curson_ = 1;
		if (conp->vc_y >= 0 && conp->vc_y < r_tty.ydim_) {
			r_tty.ypos_ = conp->vc_y;
		}
		if (conp->vc_x >= 0 && conp->vc_x < r_tty.xdim_) {
			r_tty.xpos_ = conp->vc_x;
		}
		(*r_tty.r_.render_)(&r_tty.r_,
				    r_tty.ypos_*r_tty.f_.height_,
				    r_tty.xpos_*r_tty.f_.width_,
				    &c0, 1, r_tty.fg_, r_tty.bg_, &r_tty.f_);
		break;
	case CM_ERASE:
		r_tty.curson_ = 0;
		(*r_tty.r_.render_)(&r_tty.r_,
				    r_tty.ypos_*r_tty.f_.height_,
				    r_tty.xpos_*r_tty.f_.width_,
				    &c0, 1, r_tty.bg_, r_tty.fg_, &r_tty.f_);
		break;
	default:
		;
	}

	return 0;
}
#endif

int hcon_scroll(struct hconsole *t,
        int d, int b, int dir, int count)
{
	struct rfont *f = t->f_;
	int rc;

	if (count < 0) return -1;
	if (count == 0) return 0;

	if (t->curson_) {
		char c0 = 0; /* c0 = *conp->vc_pos & 0xFF; */

		(*t->r_->render_)(t->r_,
				    t->ypos_*f->height_, t->xpos_*f->width_,
				    &c0, 1, t->bg_, t->fg_, f);
	}

	rc = 0;
	if (dir == SM_UP) {
		if (d < 0 || d >= t->ydim_) return -1;
		if (b <= d || b > t->ydim_) return -1;
		if (d + count >= b) count = b - d;
		if (d + count >= b) count = b - d;
		(*t->r_->yscroll_)(t->r_,
				     d*f->height_, 0,
				     b*f->height_-1, raster_qwidth(t->r_),
				     -(count*f->height_));
		(*t->r_->clear_)(t->r_,
                                   (b - count)*f->height_, 0,
				   count*f->height_, raster_qwidth(t->r_),
				   t->bg_);
	} else if (dir == SM_DOWN) {
		if (d < 0 || d >= t->ydim_) return -1;
		if (b <= d || b > t->ydim_) return -1;
		if (d + count >= b) count = b - d;
		(*t->r_->yscroll_)(t->r_,
				     d*f->height_, 0,
				     b*f->height_-1, raster_qwidth(t->r_),
				     count*f->height_);
		(*t->r_->clear_)(t->r_,
				   d*f->height_, 0,
				   count*f->height_, raster_qwidth(t->r_),
				   t->bg_);
	} else {
		/* XXX Not on this time */
		rc = -1;
	}

	if (t->curson_) {
		char c0 = 0; /* c0 = *conp->vc_pos & 0xFF; */

		(*t->r_->render_)(t->r_,
				    t->ypos_*f->height_, t->xpos_*f->width_,
				    &c0, 1, t->fg_, t->bg_, f);
	}

	return rc;
}

#if 0
/*
 * The name is expected to be a buffer of [FB_NM_MAX+1].
 */
static int
sparc_rconsole_probe(struct raster *r, char *name, int *color)
{
	int st_p;
	union {
		char c[4];
		unsigned char *p;
		__u32 u;
	} pb1;
	int depth, linebytes, width, /* awidth, */ height;
	int propl;
	struct linux_sbus_device *xp;

	switch(prom_vers) {
	case PROM_V0:
		/* V0 proms are at sun4c only. Can skip many checks. */
		if (SBus_chain == 0) goto drop1;     /* CONFIG_SBUS=n */
		xp = SBus_chain->devices;
		for (;;) {
			if (xp == 0) goto drop1;
			st_p = xp->prom_node;

			/* If it has no "address" than it is not the PROM console. */
			if (strncmp(xp->prom_name, "cgsix", FB_NM_MAX) == 0 ||
				strncmp(xp->prom_name, "cgthree", FB_NM_MAX) == 0 ||
				strncmp(xp->prom_name, "bwtwo", FB_NM_MAX) == 0)
			{
				if (xp->num_vaddrs != 0) break;
			}

			xp = xp->next;
		}
		pb1.u = xp->sbus_vaddrs[0];
		strncpy(name, xp->prom_name, FB_NM_MAX);
		break;
	case PROM_V2:
	case PROM_V3:
	case PROM_P1275:
		st_p = (*romvec->pv_v2devops.v2_inst2pkg)(*romvec->pv_v2bootargs.fd_stdout);

		/*
		 * Determine the type of hardware accelerator.
		 */
		propl = prom_getproperty(st_p, "emulation", name, FB_NM_MAX);
		if (propl < 0 || propl >= FB_NM_MAX) {
			/* Early cg3s had no "emulation". */
			propl = prom_getproperty(st_p, "name", name, FB_NM_MAX);
			if (propl < 0) {
				printk("console: no device name!!\n");
				goto drop1;   /* Don't panic here, be robust. */
			}
		}
		/* P3: I never saw a cg14, test it Werner. */
		if (strncmp(name, "cgsix", FB_NM_MAX) != 0 &&
		    strncmp(name, "cgthree", FB_NM_MAX) != 0 &&
		    strncmp(name, "cgfourteen", FB_NM_MAX) != 0)  /* XXX */
		{
			printk("console: \"%s\" is unsupported\n", name);
			goto drop1;
		}

		propl = prom_getproperty(st_p, "address", pb1.c, 4);
		if (propl != 4) {
			printk("console: \"address\" is missing\n");
			goto drop1;
		}
		break;
	default:
		goto drop1;
		/* st_p = 0;	*/	/* Suppress warning from gcc */
	};

	if ((depth = prom_getint(st_p, "depth")) == -1) {
		printk("console: \"depth\" is missing\n");
		goto drop1;
	}

	linebytes = prom_getintdefault(st_p, "linebytes", 1152);
	width = prom_getintdefault(st_p, "width", 1152);
	/* P3: I fear this strips 15" 1024/768 PC-like monitors out. */
	if ((linebytes*8) / depth != width) {
		printk("console: UNUSUAL VIDEO, linebytes=%d, width=%d, depth=%d\n",
			linebytes, width, depth);
		goto drop1;
	}

	height = prom_getintdefault(st_p, "height", 900);

	/* printk("console: %dx%dx%d @0x%x\n", width, height, depth, pb1.u); */

	if (depth == 8) {
		*color = 1;
		raster8_cons_a(r, height, width, pb1.p);
	} else if (depth == 1) {
		*color = 0;
		raster1_cons_a(r, height, width, pb1.p);
	} else {
		printk("console: depth %d is unsupported\n", depth);
		goto drop1;
	}

	/* (*r->render_)(r, 3, 3, "Linux", 5, 255, 0, &f_master); */
	/* (*r->clear_)(r,  3, 62, 1, 1, 255); */
	/* (*r->clear_)(r,  4, 62, 1, 1, 255); */
	/* (*r->clear_)(r,  5, 62, 1, 2, 255); */
	/* (*r->clear_)(r,  6, 62, 1, 2, 255); */
	/* (*r->clear_)(r,  7, 62, 1, 3, 255); */
	/* (*r->clear_)(r,  8, 62, 1, 3, 255); */
	/* (*r->clear_)(r,  9, 62, 1, 4, 255); */
	/* (*r->clear_)(r, 10, 62, 1, 4, 255); */
	/* (*r->clear_)(r, 11, 62, 1, 5, 255); */
	/* (*r->clear_)(r, 12, 62, 1, 5, 255); */
	/* (*r->clear_)(r, 13, 62, 1, 6, 255); */
	/* (*r->clear_)(r, 14, 62, 1, 6, 255); */
	/* (*r->clear_)(r, 15, 62, 1, 7, 255); */
	/* (*r->clear_)(r, 16, 62, 1, 7, 255); */
	/* (*r->clear_)(r, 17, 62, 1, 8, 255); */
	/* (*r->clear_)(r, 18, 62, 1, 8, 255); */

	return 0;

drop1:
	return -1;
}

unsigned long hcon_startup(
	unsigned long kmem_start,
	unsigned long *ydim, unsigned long *xdim,
	char **mnemo)
{

	font_cons_7(&f_master);
	r_tty.f_ = f_master;

	if (sparc_rconsole_probe(&r_master, r_tty.name_, &r_tty.color_) != 0) {
		/* hcon_startup interface does not allow us to fallback
		 * to a prom console.
		 */
		prom_printf("Cannot probe frame buffer\n");
		prom_halt();
	};

	/* If we fall back to PROM than our output have to remain readable. */
	prom_putchar('\033');  prom_putchar('[');  prom_putchar('H');

	/*
	 * Now define the console in a convinient way.
	 * We probably will move the window later.
	 */
	{
		unsigned h1, w1;

		h1 = raster_qheight(&r_master) - 2*RCON_NICEMARGIN;
		h1 -= h1 % f_master.height_;
		w1 = raster_qwidth(&r_master) - 2*RCON_NICEMARGIN;
		w1 -= w1 % f_master.width_;
		raster_cons_2(&r_tty.r_, &r_master,
			      (raster_qheight(&r_master) - h1) / 2,
			      (raster_qwidth(&r_master)  - w1) / 2,
			      h1, w1);

		/* P3: Palette is twisted in a strange way in my SS2/cg6.  */
		/* By default 255 maps to black, 0 maps to white.          */
		/* (*r_console.clear_)(&r_console, 0, 0, h1, w1, 255); */
	}

	r_tty.ydim_ = raster_qheight(&r_tty.r_)/r_tty.f_.height_;
	r_tty.xdim_ = raster_qwidth(&r_tty.r_)/r_tty.f_.width_;

	r_tty.bg_ = 255;
	r_tty.fg_ = 0;

	r_tty.ypos_ = 0;
	r_tty.xpos_ = 0;
	r_tty.curson_ = 1;

	init_timer(&r_tty.timer_);

	*mnemo = r_tty.name_;
	*ydim = r_tty.ydim_;
	*xdim = r_tty.xdim_;
	return kmem_start;
}
#endif
