/**
 ** Proll (PROM replacement)
 ** Copyright 1999 Pete Zaitcev
 ** This code is licensed under GNU General Public License.
 **/
#include <stdarg.h>
#if 0
#include "pcic.h"  /* P3 */
#include <linux/pci.h> /* P3 */
#endif

#include <asm/contregs.h>
#include <asm/asi.h>
#include "pgtsrmmu.h"
#include "phys_jk.h"
#include "vconsole.h"
#include "version.h"
#include <general.h>		/* __P() */
#include <net.h>		/* init_net() */
#include <romlib.h>		/* we are a provider for part of this. */
#include <netpriv.h>		/* myipaddr */
#include <arpa.h>
#include <system.h>		/* our own prototypes */
#include <silo_arg.h>		/* Interface to SILO */

#if 0
void bridge(void);
#endif
int load_pre(struct silo_to_proll *ap);

extern void *init_openprom_silo(int bankc, struct bank *bankv, unsigned hibas,
    struct silo_to_proll *p);

struct vconterm dp0;
struct mem cmem;		/* Current memory, virtual */
struct mem cio;			/* Current I/O space */
struct phym pmem;		/* Current phys. mem. */
struct pcic cpcic;		/* Current PCIC. */

/*
 * This struct must be pre-initialized,
 * or our bss cleaning zaps parameters that were patched in.
 */
struct silo_to_proll silo_arg = {	/* <== Will be patched when loading */
   { "LROP" }
};

/*
 */
void prolmain()
{
	static struct banks bb;
	int nmegs;
	int i;
	unsigned int hiphybas;
	void *romvec;

	vcon_init(&dp0, PHYS_JK_SU_A);
	printk("PROLL %s Espresso Serial+SILO\n", PROLL_VERSION_STRING);

	get_banks_layout(&bb, BANKS_JK);
	if (bb.nbanks <= 0) {
		printk("No memory found\n");
		return;
	} else {
		nmegs = 0;
		for (i = 0; i < bb.nbanks; i++) {
			printk("bank %d 0x%x[0x%x]\n", i,
			    bb.bankv[i].start, bb.bankv[i].length);
			nmegs += bb.bankv[i].length/(1024*1024);
		}
		printk("%d MB total\n", nmegs);
	}

	i = bb.nbanks - 1;
	hiphybas = bb.bankv[i].start + bb.bankv[i].length - PROLSIZE;
	/* printk("high phys base 0x%x\n", hiphybas); */ /* P3 */

	/*
	 * We generate tables and switch two times.
	 * We start off being in low physical memory (LOADBASE) and
	 * mapped to high virtual (PROLBASE), running off PROM tables.
	 * These tables are located somewhere in upper physical so
	 * when we copy ourselves up we may step on them. The
	 * solution is to create temporary pages in low physical memory,
	 * then use them to move ourselves high. After that we may
	 * create new tables in high physical memory.
	 */

	mem_init(&cmem, (char *) &_end, (char *)(PROLBASE+PROLSIZE));
	makepages(&pmem, LOADBASE);
#if 0
	proc_tablewalk(0, PROLBASE+PROLSIZE-PAGE_SIZE);
	mem_tablewalk((pmem.pctp[0]&(~0xF))<<4, PROLBASE+PROLSIZE-PAGE_SIZE);
#endif
	init_mmu_swift((unsigned int)pmem.pctp - PROLBASE + LOADBASE);
	move_phys_high(hiphybas, PROLSIZE);
	/*
	 * We did not use the dynamic memory for anything but
	 * page tables, which are left down in low memory. Reinitiate cmem.
	 */
	mem_fini(&cmem);
	mem_init(&cmem, (char *) &_end, (char *)(PROLBASE+PROLSIZE));
	makepages(&pmem, hiphybas);
	init_mmu_swift((unsigned int)pmem.pctp - PROLBASE + hiphybas);

	mem_init(&cio, (char *)(PROLBASE+PROLSIZE),
	    (char *)(PROLBASE+PROLSIZE+IOMAPSIZE));

	pcic_init(&cpcic, hiphybas);

	/* PROM leaves 0, kernel sets it properly, so it's not needed. */
	/* pcic_map_irq(&cpcic, 5, 11); */

	/*
	 */
	init_eeprom();

	sched_init();
	/* if (load_flash() != 0) fatal(); */  /* deadwood */
	if (silo_arg.magic[0] == 'S' && silo_arg.magic[1] == 'i') {
		printk("Found SILO argument.\n");
		if (load_pre(&silo_arg) != 0) fatal();
	} else {
		printk("No SILO argument.\n");
		fatal();
	}

	pcic_map_irq(&cpcic, PHYS_JK_PIN_RTC, PHYS_JK_IRQ_RTC);
	romvec = init_openprom_silo(bb.nbanks, bb.bankv, hiphybas, &silo_arg);

	printk("Memory used: virt 0x%x:0x%x[%dK] iomap 0x%x:0x%x\n",
	    PROLBASE, (int)cmem.curp, ((unsigned) cmem.curp - PROLBASE)/1024,
	    (int)cio.start, (int)cio.curp);
	set_timeout(5);  while (!chk_timeout()) { }  /* P3: let me read */
	{
		void (*entry)(void *) = (void (*)(void*)) LOADBASE;
		entry(romvec);
	}

	printk("bye.\n");
	mem_fini(&cmem);
	vcon_fini(&dp0);
	/* XXX Redo head.S so that it starts kernel */
}

#if 0  /* deadwood: using kernel loaded at fixed address */
/*
 * Load kernel from flash
 */
int load_flash() {
	int len;
	unsigned int *loadptr = (unsigned int *)LOADBASE;
	unsigned long inbuf;

	inbuf = 0x20500000;		/* XXX Magic constant again, grr */
	if (ld_bypass(inbuf) != AOUT_MAGIC) {
		printk("No kernel magic at %x\n", inbuf);
		return -1;
	}

	len = (ld_bypass(inbuf+4) + 3) & (~3);		/* text */
	len += (ld_bypass(inbuf+8) + 3) & (~3);		/* data */

	if (len < 0 || len > LOWMEMSZ) {
		printk("Illegal kernel size %d(0x%x)\n", len, len);
		return -1;
	}

	inbuf += 32;		/* over a.out header */

	while (len >= 4) {
		len -= 4;

		*loadptr++ = ld_bypass(inbuf);
		inbuf += 4;
	}

	printk("Loaded %d(0x%x) bytes\n", len, len);	/* P3 */
	return 0;
}
#endif
 
/*
 * There is not a lot to do. Silo loaded stuff for us, so we move it.
 */
int load_pre(struct silo_to_proll *ap)
{
	int len;
	unsigned int *loadptr = (unsigned int *)LOADBASE;
	unsigned int *inbuf;

	len = (ap->kern_size + 3) & (~3);
	if (len < 0 || len > LOWMEMSZ) {
		printk("Illegal kernel size %d(0x%x)\n", len, len);
		return -1;
	}
	inbuf = (unsigned int *) ap->kern_base;
	printk("Kernel base 0x%x size %d(0x%x)\n", inbuf, len, len);

	while (len >= 4) {
		len -= 4;

		*loadptr++ = *inbuf++;
	}

	return 0;
}

/*
 * dvma_alloc over iommu_alloc.
 */
void *dvma_alloc(int size, unsigned int *pphys)
{
        return pcic_alloc(&cpcic, size, pphys);
}

/*
 */
unsigned long virt_to_bus(volatile void *addr)
{
	return pcic_virt_to_bus(addr);
}

/*
 * Stub for hme.c
 */
unsigned long sbus_dvma_addr(void *addr) {
	printk("sbus_dvma_addr!\n");
	return (~0);
}

/*
 */
void udelay(unsigned long usecs)
{
	int i, n = usecs * 50;
	for (i = 0; i < n; i++) { }
}

/*
 * P3 temp
 */
#define CONFIG_CMD(bus, device_fn, where) (0x80000000 | (((unsigned int)bus) << 16) | (((unsigned int)device_fn) << 8) | (where & ~3))

/*
 * Support for IDE.
 * This can be used to program values forcebly but it turns out
 * that our theorethically correct values result in garbage on the IRQ line.
 * Therefore, deadwood for now, and failure of RTFM.
 */
#if 0
void
bridge()
{
	unsigned where;
	unsigned devfn = 0x38;
	unsigned bus = 0;
	unsigned int base0;

	where = PCI_VENDOR_ID;
	st_bp_swap(PHYS_JK_PCI_CFA, CONFIG_CMD(bus,devfn,where));
	base0 = ld_bp_swap(PHYS_JK_PCI_CFD + (where & 4));
	printk(" ID %x", base0);

	where = PCI_CLASS_REVISION;
	st_bp_swap(PHYS_JK_PCI_CFA, CONFIG_CMD(bus,devfn,where));
	base0 = ld_bp_swap(PHYS_JK_PCI_CFD + (where & 4));
	printk(" CL/R %x", base0);

	where = 0x44;
	st_bp_swap(PHYS_JK_PCI_CFA, CONFIG_CMD(bus,devfn,where));
	/* stb_bypass(PHYS_JK_PCI_CFD + (where & 4), 0); */ /* 0x0D */
	printk(" %x", ldb_bypass(PHYS_JK_PCI_CFD + (where & 4)));
	/* PROM sets 0x1B == Level/edge transform enable, IRQ12. */

	where = 0x58;
	st_bp_swap(PHYS_JK_PCI_CFA, CONFIG_CMD(bus,devfn,where));
	/* stb_bypass(PHYS_JK_PCI_CFD + (where & 4), 0x4D); */
	printk(" %x", ldb_bypass(PHYS_JK_PCI_CFD + (where & 4)));
	/* PROM sets 0x4C e.g. SIRQI/SIRQII (nonsense, but works) */

	where = 0x75;
	/* st_bp_swap(PHYS_JK_PCI_CFA, CONFIG_CMD(bus,devfn,where)); */
	stb_bypass(PHYS_JK_PCI_CFD + (where & 4), 0);
	printk(" %x", ldb_bypass(PHYS_JK_PCI_CFD + (where & 4)));
	/* PROM leaves 0xFF here... bah */

/***
	where = 0x42;
	st_bp_swap(PHYS_JK_PCI_CFA, CONFIG_CMD(bus,devfn,where));
	stb_bypass(PHYS_JK_PCI_CFD + (where & 4), 0x80);
 ***/

	printk(" bridge done\n");
}
#endif
